////////////////////////////////////////////////////////////////////////////////
//
// Binary converter (bin -> hex dump)
//
// Version        : PELock v2.0
// Language       : Delphi
// Author         : Bartosz Wjcik (support@pelock.com)
// Web page       : https://www.pelock.com
//
////////////////////////////////////////////////////////////////////////////////

program bin2hex;

uses
  Windows, SysUtils, Dialogs;

var
  hInputFile  : DWORD;
  dwInputFile : integer;

  hOutputFile : DWORD;

  cOneByte    : char;
  szTemp      : string;
  lpTemp      : PChar;

  ofnSelect   : TOpenDialog;

  dwRead      : DWORD;
  dwWritten   : DWORD;

  i, j        : integer;

begin

  // create open dialog instance
  ofnSelect := TOpenDialog.Create(nil);

  // initialize open dialog
  ofnSelect.Title := 'Select file to convert';
  ofnSelect.Filter := 'All files (*.*)|*.*';
  ofnSelect.Options := [ofFileMustExist, ofHideReadOnly];

  if (ofnSelect.Execute = False) then Exit;

  // open input file
  hInputFile := CreateFile(PChar(ofnSelect.Files[0]), GENERIC_READ, 0, nil, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);

  if (hInputFile = INVALID_HANDLE_VALUE) then
  begin
    MessageBox(0, 'Cannot open input file!', 'Error', MB_ICONERROR);
    Exit;
  end;

  // check file size
  dwInputFile := GetFileSize(hInputFile, nil);

  if (dwInputFile = 0) then
  begin
    CloseHandle(hInputFile);
    MessageBox(0, 'Input file is empty!', 'Error', MB_ICONERROR);
    Exit;
  end;

  // create output file
  hOutputFile := CreateFile(PChar(ofnSelect.Files[0] + '.inc'), GENERIC_WRITE, 0, nil, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);

  if (hOutputFile = INVALID_HANDLE_VALUE) then
  begin
    CloseHandle(hInputFile);
    MessageBox(0, 'Cannot create output file!', 'Error', MB_ICONERROR);
    Exit;
  end;

  // convert binary to hex dump
  j := 0;

  for i := 0 to dwInputFile - 1 do
  begin

    if (j = 16) then j := 0;

    ReadFile(hInputFile, cOneByte, 1, dwRead, nil);

    if (j = 0) then WriteFile(hOutputFile, 'db ', 3, dwWritten, nil);

    szTemp := Format('$%.2X', [Integer(cOneByte)]);

    lpTemp := PChar(szTemp);

    WriteFile(hOutputFile, lpTemp^, 3, dwWritten, nil);

    Inc(j);

    if (j <> 16) and (i <> (dwInputFile - 1)) then WriteFile(hOutputFile, ', ', 2, dwWritten, nil);

    if (j = 16) then WriteFile(hOutputFile, #13#10, 2, dwWritten, nil);

  end;

  // set output file size
  SetEndOfFile(hOutputFile);

  // close handles
  CloseHandle(hInputFile);
  CloseHandle(hOutputFile);

  // release open dialog object
  ofnSelect.Free;

  // display message
  MessageBox(0, 'File successfully converted.', 'Done', MB_ICONINFORMATION);
end.
